package java.lang;
import apple2.*;

public class StringBuilder
{
	private byte[] buffer;
	
	public StringBuilder()
	{
		newBuffer(16);
	}
	public StringBuilder(int len)
	{
		newBuffer(len);
	}
	public StringBuilder(String str)
	{
		int bufsz;
		if (str.length() > 240)
			bufsz = 256;
		else
			bufsz = str.length() + 16;
		newBuffer(bufsz);
		append(str);
	}
	
	private void newBuffer(int size)
	{
		buffer = new byte[size+1];
		buffer[0] = 0;	// Set working string length
	}
	private void expandBuffer(int bufsz)
	{
		if (bufsz > 256)
			bufsz = 256;
		if (bufsz > buffer.length)
		{
			byte[] bigbuff;
			int i;

			bigbuff = new byte[bufsz];
			for (i = 0; i < buffer.length; i++)
				bigbuff[i] = buffer[i];
			buffer = bigbuff;
		}
		
	}
	public StringBuilder append(boolean b)
	{
		return this;
	}
	public StringBuilder append(char c)
	{
		if (buffer.length == buffer[0])
			expandBuffer(buffer.length + 16);
		if (buffer[0] < 255)
		{
			buffer[0]++;
			buffer[buffer[0]] = (byte)c;
		}
		return this;
	}
	public StringBuilder append(float f)
	{
		return this;
	}
	public StringBuilder append(int i)
	{
		return append(Integer.toString(i));
	}
	public StringBuilder append(Object obj)
	{
		return this;
	}
	public StringBuilder append(String str)
	{
		int i;
		
		if (buffer.length < (buffer[0] + str.length()))
			expandBuffer(buffer.length + str.length() + 16);
		for (i = 0; i < str.length(); i++)
		{
			if (buffer[0] < 255)
			{
				buffer[0]++;
				buffer[buffer[0]] = (byte)str.charAt(i);
			}
		}
		return this;
	}
	public int capacity()
	{
		return buffer.length - 1;
	}
	public int length()
	{
		return buffer[0];
	}
	public String toString()
	{
		int buffptr = vm02.call(vm02.refAsBits((Object)buffer), 0x0E) + 2; // HMEM_LOCK
		int refStr = vm02.call(buffptr, 0x46); // HSTRPL_ADD
		vm02.call(vm02.refAsBits((Object)buffer), 0x10); // HMEM_UNLOCK
		return (String)vm02.bitsAsRef((refStr & 0xFFFF) | 0x00030000 | ((refStr << 8) & 0xFF000000));
	}
}